/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import java.net.MalformedURLException;
import java.net.URL;

public class VWRMIRouterURL {
    private static final long serialVersionUID = 464L;
    private static final String ROUTER_PREFIX = "FileNET.VW.VWRouter.";
    private static final String RMI_PREFIX = "rmi://";
    private String host;
    private int port;
    private String router;
    private String m_fullRouter;

    public static String _get_FILE_DATE() {
        return "$Date:   01 Oct 2004 19:57:48  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.23  $";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRouter() {
        return this.router;
    }

    public String getFullRouter() {
        return this.m_fullRouter;
    }

    public VWRMIRouterURL(String url) throws MalformedURLException {
        int iSlash;
        String s = url;
        if (url.startsWith(RMI_PREFIX)) {
            s = url.substring(RMI_PREFIX.length());
        }
        if ((iSlash = s.indexOf(47)) == -1) {
            this.host = "localhost";
            this.port = 1099;
            this.router = s;
        } else {
            String fakeURL = "http://" + s;
            URL u = new URL(fakeURL);
            this.host = u.getHost();
            this.port = u.getPort();
            if (this.port == -1) {
                this.port = 1099;
            }
            this.router = u.getPath().substring(1);
        }
        if (this.router.startsWith(ROUTER_PREFIX)) {
            this.router = this.router.substring(ROUTER_PREFIX.length());
        }
        this.m_fullRouter = ROUTER_PREFIX + this.router;
    }

    public String toString() {
        return RMI_PREFIX + this.host + ":" + this.port + "/" + this.m_fullRouter;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"myRouter", "FileNET.VW.VWRouter.xRouter", "rmi://myHost/myRouter", "rmi://myHOst/FileNET.VW.VWRouter.yRouter", "rmi://myHost:234/zRouter", "rmi://myHost:777/FileNET.VW.VWRouter.xyzRouter"};
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                VWRMIRouterURL r = new VWRMIRouterURL(args[i]);
                System.out.println(i + ":" + args[i] + "=" + r.toString());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

